local assets =
{
	Asset("ANIM", "anim/black_box.zip"),
	Asset("ATLAS", "images/inventoryimages/black_box.xml"),
	Asset("IMAGE", "images/inventoryimages/black_box.tex"),
}

local prefabs =
{
    "book_fx"
}   

local function onread(inst, reader)

    local num_lightnings =  5
    reader:StartThread(function()
        for k = 0, num_lightnings do

            local rad = math.random(3, 15)
            local angle = k*((4*PI)/num_lightnings)
            local pos = Vector3(reader.Transform:GetWorldPosition()) + Vector3(rad*math.cos(angle), 0, rad*math.sin(angle))
            GetSeasonManager():DoLightningStrike(pos)
            Sleep(math.random( .3, .5))
        end
    end)
    return true
end

function onfinished(inst)
    inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("book_maxwell")
    inst.AnimState:SetBuild("black_box")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/black_box.xml"
    
    inst:AddComponent("book")
    inst.components.book.onread = onread
	
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(3)
	inst.components.finiteuses:SetUses(3)
    inst.components.finiteuses:SetOnFinished( onfinished )
    
    return inst
    end


return Prefab( "common/inventory/black_box", fn, assets) 